
\LoadClass[twocolumn,a4paper]{article}
%
%\providecommand{\keywords}[1]{\flushleft\textit{Key-Words:} #1}
%
% If IEEEtran.cls has not been installed into the LaTeX system files,
% manually specify the path to it like:
% \documentclass[journal]{../sty/IEEEtran}
\renewenvironment{abstract}{
  \normalfont
  \bfseries
  \list{}{
  \indent
    \labelwidth-15pt
   \leftmargin0pt \rightmargin\leftmargin
    \listparindent\parindent \itemindent0pt
	\parsep10pt
    \let\fullwidthdisplay\relax}
  \item[\hskip\labelsep \bfseries{\abstractname -}] }{\endlist}


\RequirePackage{color}

\RequirePackage{hyperref}
\RequirePackage[top=1.78cm, bottom=1.78cm, left=1.65cm, right=1.65cm,includefoot]{geometry}
\setlength\columnwidth{8.89cm}
\setlength\columnsep{0.51cm}
\setlength{\parindent}{.5cm} % Default is 15pt.



\providecommand{\keywords}[1]{\bfseries{Keywords-} #1}

\usepackage{indentfirst}
\RequirePackage{titlesec}
\renewcommand{\thesubsection}{\Alph{subsection}.}
\renewcommand{\thesection}{\Roman{section}.}

\titleformat*{\section}{\center\scshape}
\titleformat*{\subsection}{\itshape}


\titlespacing*{\section}
{0pt}{2ex}{1ex}

\titlespacing*{\subsection}
{15pt}{2ex}{0ex}
\usepackage{lettrine}

\newenvironment{tight_enumerate}{
\begin{enumerate}
  \setlength{\itemsep}{0pt}
  \setlength{\parskip}{0pt}
}{\end{enumerate}}


\titleclass{\scenario}{straight}[\chapter]
\newcounter{scenario}

\titleformat{\scenario}
  {\bfseries}{}{0em}{}
\titlespacing*{\scenario}{0pt}{3.25ex plus 1ex minus .2ex}{0ex}

\newcommand{\scenarioautorefname}{scenario}

\usepackage{graphicx}
  
\usepackage[cmex10]{amsmath}
\interdisplaylinepenalty=2500

\let\OLDthebibliography\thebibliography
\renewcommand\thebibliography[1]{
  \OLDthebibliography{#1}
  \setlength{\parskip}{0pt}
  \setlength{\itemsep}{0pt }
}

\usepackage{enumitem}
\setenumerate[1]{label={\arabic*)}} % Global setting


\renewcommand{\fnum@figure}{Fig. \thefigure}


